<?php


session_start();
include 'connection.php';
require_once '../vendor/autoload.php'; // You'll need to include the correct autoload path
file_put_contents('received_data.log', file_get_contents('php://input'));
use AfricasTalking\SDK\AfricasTalking;

// Set your API credentials
$username = 'eldowas_ussd'; // Your Africa's Talking username
$apiKey = '96c548d2bac97cd3eb0371feff832774c164f7e77d6bf679d5c99489016254c8'; // Your Africa's Talking API key

// Initialize the Africa's Talking SDK
$AT = new AfricasTalking($username, $apiKey);

// Get one of the services
$sms = $AT->sms();
// Define your short code and message
$shortCode = '25404';

$from = $_POST['from'];
$to = $_POST['to'];
$text = $_POST['text'];

if(!empty($_POST['from'])) {
    // Extract needed properties from the request body
    // $from = $req->from;
    // $to = $req->to;
    // $text = $req->text;
error_log("From: $from, Text: $text, To: $to", 3, "sms_error.log");
    if (preg_match('/\d+-\d+/', $text, $matches)){
        $applicationNo = $matches[0];
        // Respond to message if from appropriate shortcode
    if ($to === $shortCode) {
        try {
            $query = "SELECT (BalTotalDebit - BalTotalCredit) AS balance, FirstName FROM customerdetails WHERE ContractNo = ?";

            // Prepare the statement
            $stmt = $mysqli->prepare($query);

            if ($stmt === false) {
                throw new Exception("Error preparing statement: " . $mysqli->error);
            }

            // Bind the parameter
            $stmt->bind_param("s", $applicationNo);

            // Execute the query
            if ($stmt->execute()) {
                // Get the result
                $result = $stmt->get_result();

                $jsonResult = array('query' => $query, 'status' => 'success');

                if ($result->num_rows === 0) {
                    echo "Incorrect Account Number $applicationNo";
                    $responseMessage = "The Account Number you entered is incorrect.";
                    //sendResponse($from, $responseMessage);
                    $sms->send([
                        'to'     => $from,
                        //'from'  => $shortCode,
                        'message' =>  $responseMessage
                    ]);
                    http_response_code(200);
                } else {
                    $row = $result->fetch_assoc(); // Fetch the row once
                    $balance = $row['balance'];
                    $name = $row['FirstName'];
                    echo "Balance: $balance\n";
                    echo "Names: $name\n";
                    $responseMessage = "Dear ".$name.", Your Water Account ".$applicationNo." balance is KShs." . number_format($balance).". Pay via Mpesa Paybill No 511000.";
                    //sendResponse($from, $responseMessage);
                    $response   = $sms->send([
                        'to'     => $from,
                        //'from'  => $shortCode,
                        'message' =>  $responseMessage
                    ]);
                    http_response_code(200);
                }

                // Close the result set
                $result->close();
            } else {
                throw new Exception("Error executing query: " . $stmt->error);
            }

            // Close the statement
            $stmt->close();
        } catch (Exception $error) {
            echo "Error in QueryDB: " . $error->getMessage();
        }

    } else {
        echo "Something is wrong with the incoming message";
        http_response_code(400);
    }
    }else{
        http_response_code(400);
    }
    
}

?>