<?php


session_start();
include 'connection.php';
require_once '../vendor/autoload.php'; // You'll need to include the correct autoload path
file_put_contents('received_data.log', file_get_contents('php://input'));
use AfricasTalking\SDK\AfricasTalking;

// Set your API credentials
$username = 'sandbox'; // Your Africa's Talking username
$apiKey = '5146aeb4d8addc18b1761794716e71e6c9aad3c007484c98f72bfaa31063139b'; // Your Africa's Talking API key

// Initialize the Africa's Talking SDK
$AT = new AfricasTalking($username, $apiKey);

// Get one of the services
$sms = $AT->sms();
// Define your short code and message
$shortCode = '73190';

$from = $_POST['from'];
$to = $_POST['to'];
$text = $_POST['text'];

if(!empty($_POST['from'])) {
    // Extract needed properties from the request body
    // $from = $req->from;
    // $to = $req->to;
    // $text = $req->text;

    $userInput = explode(' ', $text); // Split the string by spaces
    $applicationNo = $userInput[1];

    // Respond to message if from appropriate shortcode
    if ($to === $shortCode) {
        try {
            $query = "SELECT (BalTotalDebit - BalTotalCredit) AS balance FROM customerdetails WHERE ApplicationNo LIKE ?";
            $likeAccount = '%' . $applicationNo . '%';
            // Remove white spaces
            $acc = preg_replace('/\s+/', '', $likeAccount);

            // Prepare the statement
            $stmt = $mysqli->prepare($query);

            if ($stmt === false) {
                throw new Exception("Error preparing statement: " . $mysqli->error);
            }

            // Bind the parameter
            $stmt->bind_param("s", $acc);

            // Execute the query
            if ($stmt->execute()) {
                // Get the result
                $result = $stmt->get_result();

                $jsonResult = array('query' => $query, 'status' => 'success');

                if ($result->num_rows === 0) {
                    echo "No balance found for User with $applicationNo";
                    echo json_encode(["Status" => "No Balance Found"]);
                } else {
                    $balance = $result->fetch_assoc()['balance'];
                    echo "Balance: $balance\n";
                    echo strlen($acc) . "\n";
                    $responseMessage = "Your balance is: " . number_format($balance);
                    sendResponse($from, $responseMessage);
                    http_response_code(200);
                    // echo json_encode(["Status" => "Success", "Balance" => $balance]);
                }

                // Close the result set
                $result->close();
            } else {
                throw new Exception("Error executing query: " . $stmt->error);
            }

            // Close the statement
            $stmt->close();
        } catch (Exception $error) {
            echo "Error in QueryDB: " . $error->getMessage();
        }

    } else {
        echo "Something is wrong with the incoming message";
        http_response_code(400);
    }
}

function sendResponse($recipient, $message) {
    global $shortCode;
    global $sms;
    $opts = [
        "from" => $shortCode,
        "to" => $recipient,
        "message" => $message
    ];
    // Assuming you have a function to send SMS messages
    $sms->send($opts)->then(
        function () {
            echo "Message sent successfully";
        },
        function () {
            echo "Something went wrong with message sending";
        }
    );
}
?>
